.text
.align 2
.org 0

#
# Sorts 16 integers at address 0x80 using Bubble Sort
#
# This code is for the RISC-V ISA and does not contain
# any delay slots. It avoids register-immediate 'slti',
# the 'jal' instruction (used for unconditional jumps),
# and branch instructions other than 'beq'.
#

.globl bubble_sort
.type bubble_sort, @function

bubble_sort:
        addi  a0, zero, 16              # n = 16
        addi  a1, zero, 1               # one = 1 (we don't have slti yet)

outer_loop:
        slt   t0, a0, a1                # a0 (n) < one?
        beq   t0, a1, outer_end         # t0 == 1 => yes, goto outer_end

        addi  s0, zero, 0x80            # ptr = 0x80
        add   s1, zero, zero            # i = 0
        add   s2, zero, zero            # new_n = 0

inner_loop:
        slt   t0, s1, a0                # i < n?
        beq   t0, zero, inner_end       # t0 == 0 => no, goto inner_end

        lw    s3, 0 (s0)                # s3 = *ptr
        lw    s4, 4 (s0)                # s4 = *(ptr + 4)
        slt   t0, s4, s3                # s4 < s3?
        beq   t0, zero, inner_next      # t0 == 0 => s4 >= s3 branch to inner_next

        sw    s4, 0 (s0)                # swap
        sw    s3, 4 (s0)
        add   s2, zero, s1              # new_n = i

inner_next:
        addi  s0, s0, 4                 # ptr = ptr + 4
        addi  s1, s1, 1                 # i = i + 1
        beq   zero, zero, inner_loop    # goto inner_loop (unconditional relative jump)

inner_end:
        add   a0, zero, s2              # n = new_n
        beq   zero, zero, outer_loop    # goto outer_loop (unconditional relative jump)

outer_end:
        ebreak                          # invalid instruction (causes simulator to stop)
        beq   zero, zero, outer_end     # goto outer_end (unconditional relative jump)

.data
.align 4
.org 0x80
        .word 0x00888800
        .word 0x00777700
        .word 0x00666600
        .word 0x00555500
        .word 0x00444400
        .word 0x00333300
        .word 0x00222200
        .word 0x00111100
        .word 0x00ba5e00
        .word 0x00baad00
        .word 0x00face00
        .word 0x00abba00
        .word 0x00babe00
        .word 0x00beef00
        .word 0x00dead00
        .word 0x00cafe00
        .word 0x00f00d00
